//-------------------------
// ------- General sketch informations
//-------------------------
// This sketch is delivered as simple SimHub compatible arduino pro micro leds driver. 
// See joined documentation for details about using it.

//-------------------------
// ------- Upload protection settings
//-------------------------
// Set to 1 to enable upload protection, upload from arduino IDE will be disabled after the specified delay (UPLOAD_AVAILABLE_DELAY),
// This can be unlocked using one of the following ways :
// - by unplugging/plugging back the arduino, upload will be enabled for the defined time.
// - by sending the magic string on the serial port : (0xFF)(0xFF)(0xFF)(0xFF)(0xFF)(0xFF)unloc
#define ENABLE_UPLOAD_PROTECTION 0
// Delay (in ms) after the arduino startup (plug/unplug/reset) where the upload will be available, after this delay upload will be locked.
#define UPLOAD_AVAILABLE_DELAY 15000

//-------------------------
// ------- LED STRIP #1 Settings
//-------------------------
// How many leds on this strip? Set to 0 to disable.
#define STRIP1_RGBLEDCOUNT 8
// Data pin
#define STRIP1_DATAPIN 6
// 0 left to right, 1 right to left
#define STRIP1_RIGHTTOLEFT 0
// Strip type (NEOPIXEL = WS2812B compatible, PL9823 = PL9823)
#define STRIP1_TYPE NEOPIXEL

//-------------------------
// ------- STRIP #2 Settings
//-------------------------
// How many leds on this strip? Set to 0 to disable.
#define STRIP2_RGBLEDCOUNT 0
// Data pin
#define STRIP2_DATAPIN 7 
// 0 left to right, 1 right to left
#define STRIP2_RIGHTTOLEFT 0
// Strip type (NEOPIXEL = WS2812B compatible, PL9823 = PL9823)
#define STRIP2_TYPE NEOPIXEL

//-------------------------
// ------- STRIP #3 Settings
//-------------------------
// How many leds on this strip? Set to 0 to disable.
#define STRIP3_RGBLEDCOUNT 0
// Data pin
#define STRIP3_DATAPIN 8
// 0 left to right, 1 right to left
#define STRIP3_RIGHTTOLEFT 0
// Strip type (NEOPIXEL = WS2812B compatible, PL9823 = PL9823)
#define STRIP3_TYPE NEOPIXEL

//-------------------------
// ------- STRIP #4 Settings
//-------------------------
// How many leds on this strip? Set to 0 to disable.
#define STRIP4_RGBLEDCOUNT 0
// Data pin
#define STRIP4_DATAPIN 9
// 0 left to right, 1 right to left
#define STRIP4_RIGHTTOLEFT 0
// Strip type (NEOPIXEL = WS2812B compatible, PL9823 = PL9823)
#define STRIP4_TYPE NEOPIXEL

// Main simhub leds core code
#include "ledscore.h"

/// <summary>
/// Initialize the arduino.
/// </summary>
void setup() {
	Serial.begin(115200);
	setupLeds();
}

/// <summary>
/// Main loop.
/// </summary>
void loop() {
	processCommands();
}
